#ifndef AY8911_H
#define AY8911_H

#define MAX_8911 5
#define ALL_8911_CHANNELS -1

struct AY8911interface
{
	INT32 num;	/* total number of 8910 in the machine */
	INT32 baseclock;
	INT32 mixing_level[MAX_8911];
    read8_handler portAread[MAX_8911];
    read8_handler portBread[MAX_8911];
    write8_handler portAwrite[MAX_8911];
    write8_handler portBwrite[MAX_8911];
	void (*handler[MAX_8911])(INT32 irq);	/* IRQ handler for the YM2203 */
};

extern INT32 ay8911_index_ym;

void AY8911_set_clock(INT32 chip, INT32 clock);
void AY8911Reset(INT32 chip);

void AY8911Update(INT32 chip, INT16** buffer, INT32 length);

void AY8911Write(INT32 chip, INT32 a, INT32 data);
INT32 AY8911Read(INT32 chip);

void AY8911Reset(INT32 chip);
void AY8911Exit(INT32 chip);
INT32 AY8911Init(INT32 chip, INT32 clock, INT32 sample_rate,
		read8_handler portAread, read8_handler portBread,
		write8_handler portAwrite, write8_handler portBwrite);

INT32 AY8911InitYM(INT32 chip, INT32 clock, INT32 sample_rate,
		read8_handler portAread, read8_handler portBread,
		write8_handler portAwrite, write8_handler portBwrite,
		void (*update_callback)(void));

INT32 AY8911Scan(INT32 nAction, INT32* pnMin);

INT32 AY8911SetPorts(INT32 chip, read8_handler portAread, read8_handler portBread,
		write8_handler portAwrite, write8_handler portBwrite);
		
void AY8911Render(INT16** buffer, INT16* dest, INT32 length, INT32 bAddSignal);
void AY8911SetRoute(INT32 chip, INT32 nIndex, double nVolume, INT32 nRouteDir);

#define BURN_SND_AY8911_ROUTE_1		0
#define BURN_SND_AY8911_ROUTE_2		1
#define BURN_SND_AY8911_ROUTE_3		2

#define AY8911SetAllRoutes(i, v, d)							\
	AY8911SetRoute(i, BURN_SND_AY8911_ROUTE_1, v, d);	\
	AY8911SetRoute(i, BURN_SND_AY8911_ROUTE_2, v, d);	\
	AY8911SetRoute(i, BURN_SND_AY8911_ROUTE_3, v, d);

#endif
